/******************************************************************************
* This file contains the declarations for different data used in ZRC Profile.
*
* Copyright (c) 2008, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from  Freescale Semiconductor.
*
******************************************************************************/
#ifndef _ZRC_PROFILE_GLOBALS_H_
#define _ZRC_PROFILE_GLOBALS_H_
#include "EmbeddedTypes.h"
#include "TS_Interface.h"
#include "NwkGlobals.h"


/******************************************************************************
*******************************************************************************
* Private Macros
*******************************************************************************
******************************************************************************/

/*  The interval in milliseconds at which 
    user command repeat frames will be transmitted. 
    Range: 0 - 100(aplcMaxKeyRepeatInterval) milliseconds */
#define gDefaultKeyRepeatInterval_c 50

/* The duration that a recipient of a user control repeated command frame 
   waits before terminating a repeated operation. 
   Range: 200 (2*aplcMaxKeyRepeatInterval) - 65535 (0xffff) */
#define gDefaultKeyRepeatWaitTime_c 200

/* The number of seeds exchange transmissions used to generate a security key. 
   Range: 0x03(aplcMinKeyExchangeTransferCount) - 0xff */
#define gDefaultExTransferCount_c   36

/* Receive confirm(on Application Layer) when a 
   user control repeat command frame is sent; This is a Freescale specific attribute */
#define gDefaultReceiveKeyRepeatCnf_c FALSE

/************************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
************************************************************************************/

/* Defines the ZRC attributes */
typedef struct zrcAttrData_tag{
  uint8_t  keyRepeatInterval;
  uint16_t keyRepeatWaitTime;
  uint8_t  keyExTransferCount;
  
  uint8_t  receiveKeyRepeatCnf;
}zrcAttrData_t;

/******************************************************************************
*******************************************************************************
* Public memory declarations
*******************************************************************************
******************************************************************************/


/* The Task Id for ZRC Profile */
extern tsTaskID_t gZRCProfileTaskID_c;
/* Zrc attributes data */
extern zrcAttrData_t  gZrcAttr;
/* The ZRC commands supported bit map specifies which user control
   commands are suported */
extern CONST uint8_t gaZRCCmdSupportedBitMap[];

/******************************************************************************
*******************************************************************************
* Private Macros
*******************************************************************************
******************************************************************************/
/****************************************************************************/

/****************************************************************************
*****************************************************************************
* Public functions
*****************************************************************************
****************************************************************************/

/* The Task for ZRC Profile and profile initialization */
extern void ZRCProfile_MainTask(event_t events);
extern void ZRCProfile_Init(void);

#endif /* _ZRC_PROFILE_GLOBALS_H_ */
